<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-2xl text-gray-800 flex items-center gap-2">
            📂 <span>EMO Uploads</span>
        </h2>
    </x-slot>

    <div class="py-10 max-w-7xl mx-auto space-y-6">

        {{-- Header + New Upload Button --}}
        <div class="flex justify-between items-center">
            <p class="text-gray-600">Manage and track your EMO file uploads.</p>
            <a href="{{ route('emo.create') }}"
               class="px-3 py-1 bg-gray-500 text-white rounded-md hover:bg-gray-700 text-xs font-semibold shadow">
                + New Upload
            </a>
        </div>

        {{-- Success Message --}}
        @if(session('success'))
            <div class="flex items-center gap-3 bg-green-50 border border-green-200 text-green-700 p-4 rounded-lg shadow-sm">
                <span class="text-xl">✅</span>
                <span>{{ session('success') }}</span>
            </div>
        @endif

        {{-- Table Card --}}
        <div class="bg-white shadow rounded p-4 overflow-x-auto">
            <table class="w-full text-sm">
                <thead class="bg-gray-100">
                <tr >
                    <th class="p-4">#</th>
                    <th class="p-4">File Name</th>
                    <th class="p-4">Records</th>
                    <th class="p-4">Uploaded On</th>
                    <th class="p-4 text-center">Actions</th>
                </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                @forelse($uploads as $u)
                    <tr class="hover:bg-gray-50 transition">
                        <td class="p-4 font-semibold text-gray-700">{{ $u->id }}</td>
                        <td class="p-4 font-medium text-gray-900 truncate max-w-xs">{{ $u->original_name }}</td>
                        <td class="p-4">
                            <span class="px-2 py-1 bg-blue-100 text-blue-700 rounded-md text-xs font-semibold">
                                {{ $u->records_count }}
                            </span>
                        </td>
                        <td class="p-4 text-gray-600">{{ $u->created_at->format('d-M-Y H:i') }}</td>
                    <td class="p-4 text-center">
						<div class="inline-flex justify-center gap-2">
							<a href="{{ route('emo.show', $u) }}"
							   class="px-3 py-1 bg-red-600 text-white rounded-md hover:bg-blue-700 text-xs font-semibold shadow">
								View
							</a>
							<a href="{{ route('emo.print', $u) }}"
							   class="px-3 py-1 bg-gray-500 text-white rounded-md hover:bg-gray-700 text-xs font-semibold shadow">
								Print
							</a>
							<!--<a href="{{ route('emo.pdf', $u) }}"
							   class="px-3 py-1 bg-red-600 text-white rounded-md hover:bg-red-700 text-xs font-semibold shadow">
								PDF
							</a>-->
						</div>
					</td>

											</tr>
                @empty
                    <tr>
                        <td class="p-6 text-center text-gray-500 italic" colspan="5">No uploads yet.</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
    </div>
</x-app-layout>
